package calculator;

import token.Tokenizer;
import expression.Expression;
import expression.BinaryOperatorExpression;
import expression.NumericExpression;

import java.util.Scanner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Calculator {
  public Calculator() {
  }

  /*
   * <Exp> ::= <Term> ['+'|'-' <Exp>]*
   * <Term> ::= <Power> ['*'|'/'|'%' <Term>]*
   * <Power> ::= <Factor> ['^' <Power>]*
   * <Factor> ::= Number
   * | '(' <Exp> ')'
   */

  private Expression Exp(Tokenizer tokenizer) {
    Expression lhs = Term(tokenizer);
    while (tokenizer.hasNextToken() &&
           "+-".contains(tokenizer.peekToken())) {
      String op = tokenizer.nextToken();
      Expression rhs = Exp(tokenizer);
      lhs = new BinaryOperatorExpression(lhs, op, rhs);
    }
    return lhs;
  }

  private Expression Term(Tokenizer tokenizer) {
    Expression lhs = Power(tokenizer);
    while (tokenizer.hasNextToken() &&
           "*/%".contains(tokenizer.peekToken())) {
      String op = tokenizer.nextToken();
      Expression rhs = Term(tokenizer);
      lhs = new BinaryOperatorExpression(lhs, op, rhs);
    }
    return lhs;
  }

  private Expression Power(Tokenizer tokenizer) {
    Expression lhs = Factor(tokenizer);
    while (tokenizer.hasNextToken() &&
        "^".contains(tokenizer.peekToken())) {
      String op = tokenizer.nextToken();
      Expression rhs = Power(tokenizer);
      lhs = new BinaryOperatorExpression(lhs, op, rhs);
    }
    return lhs;
  }

  private Expression Factor(Tokenizer tokenizer) {
    Expression retval = null;
    if (tokenizer.peekToken().equals("(")) {
      tokenizer.nextToken(); // consume "("
      retval = Exp(tokenizer);
      if (tokenizer.peekToken().equals(")"))
        tokenizer.nextToken();
    } else {
      retval = new NumericExpression(tokenizer.nextToken());
    }
    return retval;
  }

  public void run() {
    Scanner keyboard = new Scanner(System.in);

    System.out.print("Expression to evaluate: ");

    while (keyboard.hasNextLine()) {
      String line = keyboard.nextLine();
      // process the line
      line = line.trim();
      if (!line.isEmpty()) {
        Tokenizer t = new Tokenizer(line);
        Expression e = Exp(t);
        System.out.println(String.format("%s = %d",
                                         e,
                                         e.eval()));

      }
      System.out.print("Expression to evaluate: ");
    }

  }

  public static void main(String[] args) {
    Calculator client = new Calculator();
    client.run();
  }
}
