package expression;

public class BinaryOperatorExpression
  implements Expression {
  private final Expression lhs;
  private final Expression rhs;
  private final String op;
  int _precedence;

  private static int precedence(String op) {
    switch (op) {
    case "+":
    case "-":
      return 10;
    case "*":
    case "/":
    case "%":
      return 20;
    case "^":
      return 30;
    }
    return 0;
  }

  private static int eval(int left, String op, int right) {
    switch (op) {
      case "+":
        return left + right;
      case "-":
        return left - right;
      case "*":
        return left * right;
      case "/":
        return left / right;
      case "%":
        return left % right;
      case "^":
        int leftPower = 1;
        while (right > 0) {
          leftPower *= left;
          right--;
        }
        return leftPower;
    }
    return 0;
  }

  public BinaryOperatorExpression(Expression lhs, String op, Expression rhs) {
    this.lhs = lhs;
    this.op = op;
    this.rhs = rhs;
    _precedence = precedence(op);

  }
  public int eval() {
    int l = lhs.eval();
    int r = rhs.eval();
    return eval(l, op, r);
  }
  public String toString() {
    String left = lhs.toString();
    String right = rhs.toString();
    if (lhs.precedence() < _precedence)
      left = "(" + left + ")";
    if (rhs.precedence() < _precedence)
      right = "(" + right + ")";
    return String.format("%s %s %s", left, op, right);
  }

  public int precedence() {
    return _precedence;
  }
}
