package expression;

/**
 * The interface for *Expression nodes.
 *
 * The calculator parser generates trees of
 * Expression nodes and then prints and evaluates them.
 */
public interface Expression {
  /**
   * Evaluate the expression rooted at this node.
   *
   * @return the integer value of the expression
   */
  public int eval();

  /**
   * Return the precedence of the expression.
   *
   * Numbers are very high precedence; multiplication is
   * higher than addition.
   *
   */
  public int precedence();

  /**
   * Return a string representation of the expression.
   *
   * If numeric, return string of the number. If operator,
   * return string rep of lhs, operator, and rhs; if either lhs or rhs
   * has lesser precedence than current node, wrap in parentheses.
   *
   * @return string rep of expression
   */
  public String toString();
}
