package token;
public class Tokenizer {
  private String content;
  private int start;
  private int end;

  public Tokenizer(String content) {
    this.content = content;
    start = 0;
    end = 0;
    advance();
  }

  private void advance() {
    if (hasNextToken()) {
      while (end < content.length() && Character.isWhitespace(content.charAt(end))) {
        end++;
      }
      start = end;
      if ((end < content.length()) && Character.isDigit(content.charAt(start))) {
        while ((end < content.length()) &&
            Character.isDigit(content.charAt(end)))
          end++;
      } else
        end = start + 1;
    }
  }

  public boolean hasNextToken() {
    return start < content.length();
  }

  public String nextToken() {
    if (!hasNextToken())
      return null;
    String token = content.substring(start, end);
    advance();
    return token;
  }

  public String peekToken() {
    if (!hasNextToken())
      return null;
    return content.substring(start, end);
  }
}
