package expression;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

import java.util.Scanner;
import java.io.Reader;
import java.io.StringReader;

public class TestExpressionHierarchy {
  @Tag("numeric")
  @Test
  void testNumericExpressionConstructor() {
    String tokenText = "0";
    Expression exp = new NumericExpression(tokenText);
    assertNotNull(exp);
  }

  @Tag("binop")
  @Test
  void testBinaryOperatorExpressionConstructor() {
    String tokenText = "+";
    Expression exp = new BinaryOperatorExpression(null, tokenText, null);
    assertNotNull(exp);
  }

  @Tag("numeric")
  @Test
  void testNumericExpressionPrecedence() {
    String tokenText = "0";
    Expression exp = new NumericExpression(tokenText);
    assertTrue(exp.precedence() > 20);
  }

  @Tag("binop")
  @Test
  void testBinaryOperatorExpressionPrecedence() {
    String opText = "+";
    Expression lhs = new NumericExpression("25");
    Expression rhs = new NumericExpression("8");
    Expression exp = new BinaryOperatorExpression(lhs, opText, rhs);
    int expected = 10;
    assertEquals(expected, exp.precedence());

    opText = "-";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = 10;
    assertEquals(expected, exp.precedence());

    opText = "*";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = 20;
    assertEquals(expected, exp.precedence());

    opText = "/";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = 20;
    assertEquals(expected, exp.precedence());

    opText = "%";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = 20;
    assertEquals(expected, exp.precedence());
  }

  @Tag("numeric")
  @Test
  void testNumericExpressionEval() {
    String tokenText = "0";
    int expected = 0;
    Expression exp = new NumericExpression(tokenText);
    assertEquals(expected, exp.eval());

    tokenText = "10";
    expected = 10;
    exp = new NumericExpression(tokenText);
    assertEquals(expected, exp.eval());

    tokenText = "999";
    expected = 999;
    exp = new NumericExpression(tokenText);
    assertEquals(expected, exp.eval());
}

  @Tag("binop")
  @Test
  void testOpEval_Simple() {
    String opText = "+";
    Expression lhs = new NumericExpression("25");
    Expression rhs = new NumericExpression("8");
    Expression exp = new BinaryOperatorExpression(lhs, opText, rhs);
    int expected = lhs.eval() + rhs.eval();
    assertEquals(expected, exp.eval());

    opText = "-";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = lhs.eval() - rhs.eval();
    assertEquals(expected, exp.eval());

    opText = "*";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = lhs.eval() * rhs.eval();
    assertEquals(expected, exp.eval());

    opText = "/";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = lhs.eval() / rhs.eval();
    assertEquals(expected, exp.eval());

    opText = "%";
    exp = new BinaryOperatorExpression(lhs, opText, rhs);
    expected = lhs.eval() % rhs.eval();
    assertEquals(expected, exp.eval());
  }

  @Tag("binop")
  @Test
  void testOpEval_Compound() {
    // 12 + 9 * 8 = 84
    Expression exp = new BinaryOperatorExpression(new NumericExpression("12"), "+",
        new BinaryOperatorExpression(new NumericExpression("9"), "*", new NumericExpression("8")));
    int expected = 84;
    assertEquals(expected, exp.eval());

    // 6 * (12 + 9 * 8) = 504
    exp = new BinaryOperatorExpression(new NumericExpression("6"), "*", exp);
    expected = 504;
    assertEquals(expected, exp.eval());
  }

  /* Test toString */
}
