package database;

/**
 * Database
 */
public interface Database {
  /**
   * Add the given bit string to the end of the data base list.
   * Cannot have bit 31 set (must be a positive int)
   */
  public void add(String bitString);

  /**
   * Return the bit string stored at the given location in the list.
   */
  public String get(int index);

  /**
   * Return the int that is the same as the bit string stored at the
   * given location.
   */
  public int getInt(int index);

  /**
   * Return the size of the list.
   */
  public int size();
}
