package database;

import java.util.ArrayList;

/**
 * StringDatabase
 */
public class IntDatabase implements Database {
  ArrayList<Integer> data;

  public IntDatabase() {
    data = new ArrayList<>();
  }

  public void add(String bitString) {
    data.add(Integer.parseInt(bitString, 2));
  }

  public String get(int index) {
    return Integer.toBinaryString(data.get(index));
  }

  public int getInt(int index) {
    return data.get(index);
  }

  public int size() {
    return data.size();
  }
}
