package bst;

public class BST {
  class BSTNode {
    int data;
    BSTNode left;
    BSTNode right;

    public BSTNode(int data, BSTNode left, BSTNode right) {
      this.data = data;
      this.left = left;
      this.right = right;
    }

    public BSTNode(int data) {
      this(data, null, null);
    }
  }

  BSTNode root;

  public BST() {
    root = null;
  }

  public boolean isEmpty() {
    return root == null;
  }

  public int size() {
    return size(root);
  }

  private int size(BSTNode curr) {
    int sz = 0;
    if (curr != null) {
      sz = size(curr.left) + 1 + size(curr.right);
    }
    return sz;
  }

  public void add(int n) {
    root = add(root, n);
  }

  private BSTNode add(BSTNode curr, int n) {
    if (curr == null)
      return new BSTNode(n);
    if (n <= curr.data)
      curr.left = add(curr.left, n);
    else
      curr.right = add(curr.right, n);
    return curr;
  }

  public void delete(int n) {
    root = delete(root, n);
  }

  private BSTNode biggest(BSTNode curr) {
    if (curr == null)
      return null;
    if (curr.right == null)
      return curr;
    return biggest(curr.right);
  }
  private BSTNode delete(BSTNode curr, int n) {
    BSTNode retval = curr;
    if (curr != null) {
      if (n < curr.data)
        curr.left = delete(curr.left, n);
      else if (curr.data < n)
        curr.left = delete(curr.left, n);
      else {
        if (curr.left == null)
          retval = curr.right;
        else if (curr.right == null)
          retval = curr.left;
        else {
          BSTNode prev = biggest(curr.left);
          curr.data = prev.data;
          curr.left = delete(curr.left, curr.data);
        }
      }
    }
    return retval;
  }

  public String toString() {
    return toString(root);
  }

  private String toString(BSTNode curr) {
    if (curr == null)
      return "";
    return toString(curr.left) + curr.data + "\n" + toString(curr.right);
  }
}
