package bst;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

public class BSTTest {
  @Test
  void testConstructor() {
    BST bst = new BST();
    assertNotNull(bst);
  }

  @Test
  void testIsEmpty() {
    BST bst = new BST();
    assertTrue(bst.isEmpty());
    bst.add(10);
    assertFalse(bst.isEmpty());
  }

  @Test
  void testSize() {
    BST bst = new BST();
    int expected = 0;
    int actual = bst.size();
    assertEquals(expected, actual);

    bst.add(13);
    assertEquals(1, bst.size());
    bst.add(6);
    assertEquals(2, bst.size());
    bst.add(20);
    assertEquals(3, bst.size());
  }

  @Test
  void testAdd() {
    BST bst = new BST();

    bst.add(13);
    bst.add(6);
    bst.add(20);
    assertEquals("6\n13\n20\n", bst.toString());
  }

  @Test
  void testDelete() {
    BST bst = new BST();

    bst.add(13);
    bst.delete(13);
    assertTrue(bst.isEmpty());

    bst.add(11);
    bst.add(6);
    bst.add(20);
    assertEquals("6\n11\n20\n", bst.toString());
    bst.delete(11);
    assertEquals("6\n20\n", bst.toString());

    bst.add(3);
    bst.add(1);
    bst.add(5);

    assertEquals("1\n3\n5\n6\n20\n", bst.toString());
    bst.delete(3);
    assertEquals("1\n5\n6\n20\n", bst.toString());
  }
}
