package io;

import java.io.Reader;
import java.util.Scanner;

public class LineScanner {
  private Scanner base;
  private String readAhead;

  public LineScanner(Scanner base) {
    this.base = base;
    readAhead = null;
  }

  public LineScanner(String baseData) {
    this(new Scanner(baseData));
  }

  public LineScanner(Reader baseReader) {
    this(new Scanner(baseReader));
  }

  private String readNextLine() {
    String theNextLine = null;

    boolean lineRead = !base.hasNextLine();

    while (!lineRead && base.hasNextLine()) {
      String next = base.nextLine();

      String trimmed = next.trim();
      if (!trimmed.startsWith("//")) {
        theNextLine = (theNextLine == null) ? next : theNextLine + " " + next;
        if (theNextLine.endsWith("\\"))
          theNextLine = theNextLine.substring(0, theNextLine.length() - 1);
        else
          lineRead = true;
      }
    }
    return theNextLine;
  }

  public boolean hasNextLine() {
    if (readAhead == null)
      readAhead = readNextLine();

    return readAhead != null;
  }

  public String nextLine() {
    if (hasNextLine()) {
      String returning = readAhead;
      readAhead = null;
      return returning;
    }

    throw new IndexOutOfBoundsException("LineScanner: no such line");
  }
}
