package io;

import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

import java.util.Scanner;
import java.io.Reader;
import java.io.StringReader;

public class TestLineScanner {
  @Tag("constructor")
  @Test
  void testPrimaryConstructor() {
    String inputText = """
      """;

    Scanner scn = new Scanner(inputText);
    LineScanner lineScanner = new LineScanner(scn);
    assertNotNull(lineScanner);
  }

  @Tag("constructor")
  @Test
  void testStringConstructor() {
    String inputText = """
      """;

    LineScanner lineScanner = new LineScanner(inputText);
    assertNotNull(lineScanner);
  }

  @Tag("constructor")
  @Test
  void testReaderConstructor() {
    String inputText = """
      """;

    Reader reader = new StringReader(inputText);
    LineScanner lineScanner = new LineScanner(reader);
    assertNotNull(lineScanner);
  }

  /**
   * Given input for a LineScanner: build the LS and pull out lines
   * until no more next lines.
   *
   * @param inputText text to be scanned w/LineScanner
   * @return join with "\n" of all lines given by LineScanner
   */
  private String buildStringFromLineScanner(String inputText) {
    String actual = "";
    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    return actual;
  }

  @Tag("standard")
  @Test
  void testEmptyInput() {
    String inputText = """
      """;

    String expected = inputText;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("standard")
  @Test
  void testStandardLines() {
    String inputText = """
      one fish, two fish,
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String expected = inputText;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("comments")
  @Test
  void testCommentLines() {
    String inputText = """
      // begins with comment
      one fish, two fish, // not a comment
      // I am invisible!
      red fish, blue fish,
      // us,
      // too!
      green fish, yellow fish,
      lady and fellow fish.
      // ends with comment
      """;

    String expected = """
      one fish, two fish, // not a comment
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("comments")
  @Test
  void testAllCommentLines() {
    String inputText = """
      // begins with comment
      //one fish, two fish, // not a comment
      // I am invisible!
      //red fish, blue fish,
      // us,
      // too!
      //green fish, yellow fish,
      //lady and fellow fish.
      // ends with comment
      """;

    String expected = """
      """;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("continued")
  @Test
  void testContinuedLines() {
    String inputText = """
      // remember: slash-eoln becomes a space
      // and slash-slash is necessary to escape
      one fish,\\
      two fish, // not a comment
      """;

    String expected = """
      one fish, two fish, // not a comment
      """;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("continued")
  @Test
  void testContinuedContinuedLines() {
    String inputText = """
      one fish,\\
      two fish,\\
      red fish,\\
      blue fish,
      green fish, yellow fish,\\
      lady and fellow fish.
      """;

    String expected = """
      one fish, two fish, red fish, blue fish,
      green fish, yellow fish, lady and fellow fish.
      """;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }

  @Tag("continued")
  @Test
  void testContinuedComments() {
    String inputText = """
      // remember: slash-eoln becomes a space
      // and slash-slash is necessary to escape
      // spaces BEFORE continuation matter
      one fish,   \\
      two fish, // not a comment
      // do comments continue? \\
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String expected = """
      one fish,    two fish, // not a comment
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String actual = buildStringFromLineScanner(inputText);
    assertEquals(actual, expected);
  }
}
