package logger;

import java.io.PrintStream;

public class Logger {
  private static Logger instance = new Logger(System.err, 0);
  public static Logger getInstance() {
    if (instance == null) {
      instance = null;
    }
    return instance;
  }

  public Logger(PrintStream out, int debugLevel) {
    this.out = out;
    this.debugLevel = debugLevel;
  }

  private PrintStream out;
  private int debugLevel;

  public PrintStream getOut() {
    return out;
  }
  public void setOut(PrintStream out) {
    this.out = out;
  }
  public int getDebugLevel() {
    return debugLevel;
  }
  public void setDebugLevel(int debugLevel) {
    this.debugLevel = debugLevel;
  }

  public void println(int messageLevel, String message) {
    if ((debugLevel > 0) && (messageLevel >= debugLevel))
      out.println(message);
  }

  public void println(int messageLevel) {
    if ((debugLevel > 0) && (messageLevel >= debugLevel))
      out.println();
  }

  public void print(int messageLevel, String message) {
    if ((debugLevel > 0) && (messageLevel >= debugLevel))
      out.print(message);
  }

  public void info(String message) {
    println(1, "Info : " + message);
  }

  public void warning(String message) {
    println(2, "Warning : " + message);
  }

  public void error(String message) {
    println(1, "Error : " + message);
  }
}
