package logger;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

class LoggerTest {
  @Test
  void testGetInstance() {
    Logger logger = Logger.getInstance();
    assertNotNull(logger);
  }

  @Test
  void testOut() {
    Logger logger = Logger.getInstance();
    PrintStream otherOut = new PrintStream(new ByteArrayOutputStream());
    logger.setOut(otherOut);
    assertEquals(otherOut, logger.getOut());
    logger.setOut(System.out);
    assertEquals(System.out, logger.getOut());
  }

  @Test
  void testDebugLevel() {
    Logger logger = Logger.getInstance();
    logger.setDebugLevel(1);
    assertEquals(1, logger.getDebugLevel());
    logger.setDebugLevel(0);
    assertEquals(0, logger.getDebugLevel());
  }

  @Test
  void testPrintlnLevel0() {
    Logger logger = Logger.getInstance();
    ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
    PrintStream otherOut = new PrintStream(debugOut);
    logger.setOut(otherOut);
    logger.setDebugLevel(0);
    logger.println(0, "Zero Fish");
    logger.println(1, "One Fish");
    logger.println(2, "Two Fish");
    logger.println(3, "Three Fish");

    String expected = """
      """;
    String actual = debugOut.toString();
    assertEquals(expected, actual);
  }
  @Test
  void testPrintlnLevel1() {
    Logger logger = Logger.getInstance();
    ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
    PrintStream otherOut = new PrintStream(debugOut);
    logger.setOut(otherOut);
    logger.setDebugLevel(1);
    logger.println(1, "One Fish");
    logger.println(2, "Two Fish");
    logger.println(3, "Three Fish");

    String expected = """
      One Fish
      Two Fish
      Three Fish
      """;
    String actual = debugOut.toString();
    assertEquals(expected, actual);
  }

  @Test
  void testPrintlnLevel2() {
    Logger logger = Logger.getInstance();
    ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
    PrintStream otherOut = new PrintStream(debugOut);
    logger.setOut(otherOut);
    logger.setDebugLevel(2);
    logger.println(1, "One Fish");
    logger.println(2, "Two Fish");
    logger.println(3, "Three Fish");

    String expected = """
      Two Fish
      Three Fish
      """;
    String actual = debugOut.toString();
    assertEquals(expected, actual);
  }

  @Test
  void testPrintlnLevel3() {
    Logger logger = Logger.getInstance();
    ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
    PrintStream otherOut = new PrintStream(debugOut);
    logger.setOut(otherOut);
    logger.setDebugLevel(3);
    logger.println(1, "One Fish");
    logger.println(2, "Two Fish");
    logger.println(3, "Three Fish");

    String expected = """
      Three Fish
      """;
    String actual = debugOut.toString();
    assertEquals(expected, actual);
  }


}
