package application;

import java.io.FileNotFoundException;
import java.util.Scanner;

import climate.ClimateHistory;

public class ClimateDB {
  public static void main(String[] args) throws FileNotFoundException {
    if (args.length != 1) {
      System.err.println("usage: ClimateDB <data file name>");
      System.exit(1);
    }

    ClimateHistory history = new ClimateHistory(args[0]);

    Scanner keyboard = new Scanner(System.in);
    System.out.print("City? ");
    while (keyboard.hasNextLine()) {
      String city = keyboard.nextLine();
      if (city.equals("exit"))
        break;
      history.historyFor(city);
      System.out.print("City? ");
    }
  }
}
