package climate;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Scanner;

public class ClimateHistory {
  private ArrayList<TempData> history;

  public ClimateHistory(String fname) throws FileNotFoundException {
    history = new ArrayList<TempData>();

    FileInputStream fin = new FileInputStream(fname);
    Scanner in = new Scanner(fin);
    while (in.hasNextLine()) {
      String line = in.nextLine();
      Scanner lineScanner = new Scanner(line);
      int year = lineScanner.nextInt();
      int lowTemp = lineScanner.nextInt();
      String city = lineScanner.nextLine();
      city = city.substring(1);

      history.add(new TempData(year, lowTemp, city));
    }
  }

  public void historyFor(String city) {
    boolean printedAny = false;
    for (TempData curr : history) {
      if (curr.getLocation().startsWith(city)) {
        printedAny = true;
        System.out.println(String.format("%s: %d %5d F",curr.getLocation(),curr.getYear(), curr.getTempF()));
      }
     }
    if (!printedAny) {
      System.out.println("No matching temperature records found.");
    }
  }
}
