package io;

import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

import java.util.Scanner;
import java.io.Reader;
import java.io.StringReader;

public class TestLineScanner {
  @Test
  void testPrimaryConstructor() {
    String inputText = """
      """;

    Scanner scn = new Scanner(inputText);
    LineScanner lineScanner = new LineScanner(scn);
    assertNotNull(lineScanner);
  }

  @Test
  void testStringConstructor() {
    String inputText = """
      """;

    LineScanner lineScanner = new LineScanner(inputText);
    assertNotNull(lineScanner);
  }

  @Test
  void testReaderConstructor() {
    String inputText = """
      """;

    Reader reader = new StringReader(inputText);
    LineScanner lineScanner = new LineScanner(reader);
    assertNotNull(lineScanner);
  }

  @Test
  void testEmptyInput() {
    String inputText = """
      """;

    String expected = inputText;

    String actual = "";

    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    assertEquals(actual, expected);
  }

  @Test
  void testStandardLines() {
    String inputText = """
      one fish, two fish,
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String expected = inputText;

    String actual = "";

    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    assertEquals(actual, expected);
  }

  @Test
  void testCommentLines() {
    String inputText = """
      # begins with comment
      one fish, two fish, # not a comment
      # I am invisible!
      red fish, blue fish,
      # us,
      # too!
      green fish, yellow fish,
      lady and fellow fish.
      # ends with comment
      """;

    String expected = """
      one fish, two fish, # not a comment
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String actual = "";

    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    assertEquals(actual, expected);
  }

  @Test
  void testAllCommentLines() {
    String inputText = """
      # begins with comment
      #one fish, two fish, # not a comment
      # I am invisible!
      #red fish, blue fish,
      # us,
      # too!
      #green fish, yellow fish,
      #lady and fellow fish.
      # ends with comment
      """;

    String expected = """
      """;

    String actual = "";

    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    assertEquals(actual, expected);
  }

  @Test
  void testContinuedLines() {
    String inputText = """
      # remember: slash-eoln becomes a space
      # and slash-slash is necessary to escape
      one fish,\\
      two fish, # not a comment
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String expected = """
      one fish, two fish, # not a comment
      red fish, blue fish,
      green fish, yellow fish,
      lady and fellow fish.
      """;

    String actual = "";

    LineScanner lineScanner = new LineScanner(inputText);

    while (lineScanner.hasNextLine()) {
      actual += lineScanner.nextLine() + "\n";
    }
    assertEquals(actual, expected);
  }
}
