package frozen;

import java.util.InputMismatchException;
import java.util.Scanner;

public class FrozenTreat {
  /**
   * Given what should be the name of a type of FrozenTreat,
   * construct such an object using the default constructor.
   *
   * @param className name of FrozenTreat to create
   * @return a new object matching given description; if className is
   * unknown, return null
   */
  private static FrozenTreat polymorphicConstructor(String className) {
    FrozenTreat treat = null;
    switch (className) {
    case "IceCream":
      treat = new IceCream();
      break;
    case "Yoghurt":
      treat = new Yoghurt();
      break;
    case "Sundae":
      treat = new Sundae();
      break;
    }
    return treat;
  }

  public static FrozenTreat treatFactory(Scanner fScanner) {
    FrozenTreat treat = null;
    try {
      // skip blank lines
      String line = fScanner.nextLine();
      while (line.isBlank())
        line = fScanner.nextLine();

      line = line.trim(); // {<class>
      String curly = line.substring(0, 1);
      String className = line.substring(1).trim();



    } catch (InputMismatchException mismatch) {
      System.out.println("Error: treatFactory " + mismatch.getMessage());
      mismatch.printStackTrace();
      treat = null;
    }
    return treat;
  }

  protected boolean processField(String name, String value) {
    return false;
  }
  protected String describeMe() {
    return "";
  }

  public double price() {
    return 0.0;
  }

  public String toString() {
    return describeMe() + " $" + price();
  }

  /**
   * Is this frozen treat in a complete state?
   *
   * @return true - FrozenTreat has no state so it is always
   * usable.
   */
  public boolean isUsable() {
    return true;
  }
}
