package vehicle;

import java.io.IOError;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.regex.Pattern;

public class Vehicle {

  /**
   * A "polymorphic" constructor for Vehicles.
   *
   * @param className String with the type of the Vehicle to
   * construct. Constructed with the default constructor
   * @return null if className is unknown; otherwise a Vehicle
   * matching the named type
   *
   */
  private static Vehicle vehicleFactory(String className) {
    Vehicle result = null;
    switch (className) {
    case "Scooter":
      result = new Scooter();
    }
    return result;
  }

  public static String properlyNestedCurlyBraces(Scanner vScanner) {
    String retval = null;

    //Pattern prev = vScanner.delimiter();
    //vScanner.useDelimiter("");

    String lCurly = "\\{"; // escaped opening curly brace
    String rCurly = "\\}"; // escaped closing curly brace
    String notLCurly = "[^" + lCurly + "]*";
    String notAnyCurly = "[^" + lCurly + rCurly + "]*";

    Pattern pUntilLCurly = Pattern.compile(notLCurly);
    Pattern pHasLeftCurly = Pattern.compile(notLCurly + lCurly);
    Pattern pUntilAnyCurly = Pattern.compile(notAnyCurly);
    Pattern pLCurly = Pattern.compile(lCurly);
    Pattern pRCurly = Pattern.compile(rCurly);

    System.out.println("properlyNestedCurlyBraces");

    vScanner.skip(pUntilLCurly);

    retval = vScanner.findWithinHorizon(pLCurly, 0);

    if (retval == null) return retval;
    while (vScanner.hasNext(pUntilAnyCurly)) {
      System.out.println(String.format("properlyNestedCurlyBraces building [%s]", retval));
      retval += vScanner.findWithinHorizon(pUntilAnyCurly, 0);
      if (vScanner.hasNext(pLCurly)) {
        retval += properlyNestedCurlyBraces(vScanner);
      }
    }
    retval += vScanner.findWithinHorizon(pRCurly, 0);

    System.out.println(String.format("properlyNestedCurlyBraces [%s]", retval));

    //vScanner.useDelimiter(prev);
    return retval;
  }

  /**
   *
   * @note assumes there is a complete Vehicle record at or below the
   * current read position in the Scanner. Returns null as result of
   * failed read operation.
   */
  public static Vehicle vehicleFactory(Scanner vScanner) {
    Vehicle vehicle = null;
    String expected = "";
    try {
      //Pattern prev = vScanner.delimiter();
      //vScanner.useDelimiter("");

      String wSpace = "\s*"; // unlimited whitespace char
      String lCurly = "\\{"; // escaped opening curly brace
      String rCurly = "\\}"; // escaped closing curly brace
      String notLCurly = "[^" + lCurly + "]*";
      String notAnyCurly = "[^" + lCurly + rCurly + "]*";
      String fieldName = "\\p{Alpha}\\p{Alnum}*";
      String closeOrField = "(?:" + rCurly + ")|(?:"  + fieldName + ")";

      // Pattern is a regular expression type
      Pattern pWhitespace = Pattern.compile(wSpace);
      Pattern pUntilLCurly = Pattern.compile(notLCurly);
      Pattern pHasLeftCurly = Pattern.compile(notLCurly + lCurly);
      Pattern pUntilAnyCurly = Pattern.compile(notAnyCurly);
      Pattern pLCurly = Pattern.compile(lCurly);
      Pattern pRCurly = Pattern.compile(rCurly);
      Pattern pFieldName = Pattern.compile(fieldName);
      Pattern pCloseOrField = Pattern.compile(closeOrField);
      /*
       * Processing: Skip whitespace until {; there will be an
       * exception if next non-whitespace is not {.
       */

      vScanner.skip(pWhitespace);

      // this may or may not match
      expected = "{";
      vScanner.next(pLCurly);

      // Next is the class name (field name pattern)
      vScanner.skip(pWhitespace);
      expected = "<classname>";
      String vehicleType = vScanner.next(pFieldName);

      System.out.println(vehicleType);


      vehicle = vehicleFactory(vehicleType);



      /*


      line = line.trim();
      // line = {<Class Name>
      if (line.substring(0, 1).equals("{")) {
        line = line.substring(1).trim(); // lop off curly brace
        System.out.println(String.format("Class: %s", line));

        result = vehicleFactory(line);

        Pattern previousDelimiter = vScanner.delimiter();
        vScanner.useDelimiter("}");
        String body = vScanner.next();
        vScanner.useDelimiter(previousDelimiter);

        Scanner bodyScanner = new Scanner(body);
        bodyScanner.useDelimiter(";");
        int fieldCount = 0;
        while (bodyScanner.hasNext()) {
          String field = bodyScanner.next().trim();
          if (field.isBlank())
            continue;

          String[] parts = field.split("\s*:\s*");

          String name = parts[0];
          String value = parts[1];
          System.out.println(String.format("Field[%d] - '%s':'%s'",fieldCount, name, value));
          fieldCount++;
        }
        } */
    } catch (InputMismatchException e) {
      System.err.printf("Factory InputMismatchException on \"%s\"\n", expected);
      e.printStackTrace(System.err);
      vehicle = null;
    }
    return vehicle;
  }
}
