package main;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Scanner;

import rlinked.ListOfFruit;
import fruit.Apple;
import fruit.Fruit;
import fruit.Pear;
import fruit.Orange;

public class UseLinkedList {
  String dataFileName;
  ListOfFruit fruits;

  public UseLinkedList(String dataFileName) {
    this.dataFileName = dataFileName;
    fruits = new ListOfFruit();
  }

  public void loadFromFile() {
    try {
      FileInputStream in = new FileInputStream(dataFileName);
      Scanner scanner = new Scanner(in);
      while (scanner.hasNextLine()) {
        String line = scanner.nextLine();
        Scanner lineScanner = new Scanner(line);
        String fruitType = lineScanner.next();
        String fruitVariety = lineScanner.next();
        Fruit fruit = null;;
        if (fruitType.equals("Apple")) {
          fruit = new Apple(fruitVariety);
        } else if (fruitType.equals("Pear")) {
          fruit = new Pear(fruitVariety);
        } else if (fruitType.equals("Orange")) {
          fruit = new Orange(fruitVariety);
        }

        if (fruit != null) {
          fruits.add(fruit);
        } else {
          System.err.println(String.format("Unknown Fruit Type: %s - ignoring", fruitType));
        }
      }
    } catch (FileNotFoundException e) {
      System.out.println("Error " + e.getMessage());
      e.printStackTrace();
    }

  }
  public void run() {
    loadFromFile();
    System.out.println("Loaded file " + dataFileName);
    Scanner keyboard = new Scanner(System.in);
    boolean done = false;
    System.out.print("Cmd> ");
    while (!done && keyboard.hasNext()) {
      String cmd = keyboard.next();
      if ("quit".startsWith(cmd)) {
        done = true;
      } else if ("print".startsWith(cmd)) {
        System.out.println("====================================================");
        System.out.println(fruits);
        System.out.println("====================================================");
      } else if ("delete".startsWith(cmd)) {
        System.out.print("Fruit type: ");
        String fruit = keyboard.next();
        System.out.print("Fruit variety: ");
        String variety = keyboard.next();
        System.out.println(String.format("Attempting to delete %s:%s", fruit, variety));
        if (fruits.delete(fruit, variety)) {
          System.out.println(String.format("%s:%s deleted.", fruit, variety));
        } else {
          System.out.println(String.format("%s:%s - NOT FOUND", fruit, variety));
        }
      } else {
        System.err.println(String.format("Unknown command \"%s\".", cmd));
        System.err.println("Known: quit, print, delete");
      }
      if (!done)
        System.out.print("Cmd> ");
    }
  }

  public static void main(String[] args) {
    if (args.length > 0) {
      UseLinkedList app = new UseLinkedList(args[0]);
      app.run();
    } else {
      System.err.println("UseLinkedList <fruit-file-path>");
      System.exit(3);
    }
  }

}
