package rlinked;

import fruit.Apple;
import fruit.Fruit;
import fruit.Pear;
import fruit.Orange;

public class ListOfFruit {
  /**
   * ListOfFruitNode
   * Node for the linked list.
   */
  private class ListOfFruitNode {
    final Fruit fruit;
    ListOfFruitNode next;

    public ListOfFruitNode(Fruit myFruit, ListOfFruitNode next) {
      fruit = myFruit;
      this.next = next;
    }

    public ListOfFruitNode(Fruit myFruit) {
      this(myFruit, null);
    }
  }

  private ListOfFruitNode head;

  public ListOfFruit() {
    head = null;
  }

  public void add(Fruit newFruit) {
    ListOfFruitNode newbie = new ListOfFruitNode(newFruit);
    if (head == null) {
      head = newbie;
    } else {
      ListOfFruitNode curr = head;
      while (curr.next != null)
        curr = curr.next;
      curr.next = newbie;
    }
  }

  public boolean contains(String fruitName, String varietyName) {
    return contains(head, fruitName, varietyName);
  }

  private boolean contains(ListOfFruitNode curr, String fruitName, String varietyName) {
    return (curr != null) &&
      (curr.fruit.match(fruitName, varietyName) ||
       contains(curr.next, fruitName, varietyName));
  }

  public boolean delete(String fruitName, String varietyName) {
    boolean actuallyDeleted = false;
    if (contains(fruitName, varietyName)) {
      head = delete(head, fruitName, varietyName);
      actuallyDeleted = true;
    }
    return actuallyDeleted;
  }

  private ListOfFruitNode delete(ListOfFruitNode curr, String fruitName, String varietyName) {
    ListOfFruitNode rest = curr;
    if (curr == null)
      rest = null;
    else if (curr.fruit.match(fruitName, varietyName))
      rest = curr.next;
    else
      curr.next = delete(curr.next, fruitName, varietyName);
    return rest;
  }

  public String toString() {
    String strRepresentation = "";
    String separator = "";
    ListOfFruitNode curr = head;
    while (curr != null) {
      strRepresentation = String.format("%s%s%s", strRepresentation,
                                        separator,
                                        curr.fruit);
      separator = "\n";
      curr = curr.next;
    }
    return strRepresentation;
  }
}
