/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package reverse;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import util.Stack;

public class ByWord {
  private int textWidth;
  private String fname;


  public ByWord(String fname, int textWidth) {
    this.fname = fname;
    this.textWidth = textWidth;
  }

  public ByWord() {
    this(null, 60);
  }

  public void run() {
    try {
      Scanner fin;
      if ((fname != null) && (!fname.equals("-")))
        fin = new Scanner(new File(fname));
      else
        fin = new Scanner(System.in);

      // fill the stack
      Stack<String> words = new Stack<String>();

      while (fin.hasNext()) {
        words.push(fin.next());
      }

      // empty the stack with justified lines
      int width = 0;
      String space = "";
      while (!words.isEmpty()) {
        String nextWord = words.pop();
        if ((width + nextWord.length() + space.length()) > textWidth) {
          System.out.println();
          width = 0;
          space = "";
        }
        System.out.print(space + nextWord);
        width += nextWord.length() + space.length();
        space = " ";
      }
      System.out.println();
    } catch (FileNotFoundException e) {
      System.err.println("Error " + e.getMessage());
      e.printStackTrace();
    }
  }

  public static void main(String[] args) {
    String fname = null;
    int width = 60;
    if (args.length > 0)
      fname = args[0];
    if (args.length > 1)
      width = Integer.parseInt(args[1]);
    ByWord reverseByWord = new ByWord(fname, width);
    reverseByWord.run();
  }
}
