package util;
public class Stack<E> {
  class StackNode<E> {
    public E data;
    public StackNode next;
    public StackNode(E data, StackNode<E> next) {
      this.data = data;
      this.next = next;
    }

    public StackNode(E data) {
      this(data, null);
    }
  }

  StackNode<E> top;

  public Stack() {
    top = null;
  }

  public boolean isEmpty() {
    return top == null;
  }

  public void push(E data) {
    top = new StackNode<E>(data, top);
  }

  public E pop() {
    E retval = null;
    if (!isEmpty()) {
      retval = top.data;
      top = top.next;
    }
    return retval;
  }

  public E peek() {
    E retval = null;
    if (!isEmpty()) {
      retval = top.data;
    }
    return retval;
  }
}
