public class DoublyLinkedCircularList<E> {
  class DLCLNode<E> {
    E data;
    DLCLNode prev;
    DLCLNode next;

    DLCLNode(DLCLNode prev, E data, DLCLNode next) {
      nodeCounter++;
      this.prev = prev;
      this.data = data;
      this.next = next;
    }
  }

  DLCLNode list;
  int nodeCounter;

  public DoublyLinkedCircularList() {
    nodeCounter = 0;
    list = new DLCLNode<E>(null, null, null);
    list.next = list;
    list.prev = list;
  }

  public int length() {
    int len = 0;
    for(DLCLNode curr = list.next; curr != list; curr = curr.next, len++);
    return len;
  }

  public void append(E data) {
    DLCLNode newLast = new DLCLNode<E>(list.prev, data, list);
    list.prev.next = newLast;
    list.prev = newLast;
  }

  public void prepend(E data) {
    DLCLNode newFirst = new DLCLNode<E>(list, data, list.next);
    list.next.prev = newFirst;
    list.next = newFirst;
  }

  public String toString() {
    String retval = String.format("length = %d, nodeCounter = %d\n", length(), nodeCounter);
    String separator = "";
    for(DLCLNode curr = list.next; curr != list; curr = curr.next) {
      retval += String.format("%s%s", separator, curr.data);
      separator = ", ";
    }
    return retval;
  }

}
