public class AdderB {
  /**
   * main method:
   * checks number of parameters on the command-line.
   * general solution: loop across args, adding the double values.
   */
  public static void main(String[] args) {
    double sum = 0;
    int count = 0;

    if (args.length == 1) {
      System.out.println("1 values added; sum = " + args[0] + ".00");
    } else {
      for (String arg : args) {
        try {
          double number = Double.parseDouble(arg);
          sum += number;
          count++;
        } catch (NumberFormatException e) {
          System.out.printf("\"%s\" is not a number.\n", arg);
        }
      }
      System.out.printf("%d values added; sum = %4.2f\n", count, sum);
    }
  }
}
