package calculator;

import tree.Tree;
import visitor.Visitor;
import visitor.CommaVisitor;
import visitor.SumVisitor;
import java.util.Scanner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Calculator {


  public Calculator() {
  }

  public void run() {


    Tree bt = new Tree();

    bt.add("50");
    bt.add("25");
    bt.add("75");
    bt.add("35");
    bt.add("55");
    bt.add("05");

    Visitor cv = new CommaVisitor();
    bt.inOrder(cv);
    System.out.println(String.format("CommaVistor.result() = %s", cv.result()));

    cv = new CommaVisitor();
    bt.preOrder(cv);
    System.out.println(String.format("CommaVistor.result() = %s", cv.result()));

    Visitor sv = new SumVisitor();
    bt.inOrder(sv);
    System.out.println(String.format("SumVistor.result() = %s", sv.result()));


  }

  public static void main(String[] args) {
    Calculator client = new Calculator();
    client.run();
  }
}
