package tree;
import visitor.*;
public class Tree {
    class Node {
      String data;
      Node left;
      Node right;

      Node(String data, Node left, Node right) {
        this.data = data;
        this.left = left;
        this.right = right;
      }

      Node(String data) {
        this(data, null, null);
      }
    }

    Node root;

    public Tree() {
      root = null;
    }

    public void add(String newbie) {
      if (root == null)
        root = new Node(newbie);
      else
        add(root, newbie);
    }

    private void add(Node curr, String newbie) {
      if (curr.data.compareTo(newbie) < 0) { // go right
        if (curr.right == null)
          curr.right = new Node(newbie);
        else
          add(curr.right, newbie);
      } else { // go left
        if (curr.left == null)
          curr.left = new Node(newbie);
        else
          add(curr.left, newbie);
      }
    }

    public void inOrder(Visitor iO) {
      inOrder(root, iO);
    }

    private void inOrder(Node curr, Visitor iO) {
      if (curr != null) {
        inOrder(curr.left, iO);
        iO.apply(curr.data);
        inOrder(curr.right, iO);
      }
    }

    public void preOrder(Visitor preO) {
      preOrder(root, preO);
    }

    private void preOrder(Node curr, Visitor preO) {
      if (curr != null) {
        preO.apply(curr.data);
        preOrder(curr.left, preO);
        preOrder(curr.right, preO);
      }
    }
  }
