(TeX-add-style-hook
 "lTreeTraceStack"
 (lambda ()
   (setq TeX-command-extra-options
         "-shell-escape")
   (TeX-add-to-alist 'LaTeX-provided-class-options
                     '(("exam" "answers" "addpoints" "10pt")))
   (TeX-add-to-alist 'LaTeX-provided-package-options
                     '(("tcolorbox" "most")))
   (add-to-list 'LaTeX-verbatim-environments-local "lstlisting")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "href")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperimage")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "hyperbaseurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "nolinkurl")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "url")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-braces-local "lstinline")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "path")
   (add-to-list 'LaTeX-verbatim-macros-with-delims-local "lstinline")
   (TeX-run-style-hooks
    "latex2e"
    "exam"
    "exam10"
    "amsmath"
    "amssymb"
    "cancel"
    "tcolorbox"
    "datetime"
    "enumerate"
    "xltxtra"
    "listings"
    "graphicx"
    "hyperref"
    "makecell"
    "multicol"
    "multirow"
    "soul"
    "tabularx"
    "textcomp"
    "tikz"
    "tikz-qtree"
    "pgf-umlcd"
    "fontspec")
   (TeX-add-symbols
    "checkpoint"
    "assignmentTitle"
    "semester"
    "className"
    "classNumber"
    "classFullName")
   (LaTeX-add-environments
    '("showExample" 1))
   (LaTeX-add-xcolor-definecolors
    "outputgray"))
 :latex)

