package animals;
public class Animal
  implements Comparable<Animal> {
  private final String name;
  private final String description;

  public Animal(String name, String description) {
    this.name = name;
    this.description = description;
  }

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  @Override
  public int compareTo(Animal other) {
    return name.compareTo(other.name);
  }

  public int compareTo(String name) {
    return this.name.compareTo(name);
  }

  @Override
  public String toString() {
    return String.format("%s - %s", name, description);
  }
}
