package animals;
public class Dictionary {
  class Node {
    Animal data;
    Node left;
    Node right;

    Node(Animal data) {
      this.data = data;
      left = null;
      right = null;
    }
  }

  Node root;

  public Dictionary() {
    root = null;
  }

  public boolean contains(String maybe) {
    return contains(root, maybe);
  }

  private boolean contains(Node curr, String maybe) {
    boolean found = false;
    if (curr != null) {
      int match = curr.data.compareTo(maybe);
      if (match < 0)
        found = contains(curr.right, maybe);
      else if (match == 0)
        found = true;
      else
        found = contains(curr.left, maybe);
    }

    return found;
  }

  public boolean delete(String victim) {
    if (contains(victim)) {
      root = delete(root, victim);
      return true;
    }
    return false;
  }

  private Node smallest(Node curr) {
    while (curr.left != null)
      curr = curr.left;

    return curr;
  }

  private Node delete(Node curr, String victim) {
    Node retval = curr;
    if (curr != null) {
      int match = curr.data.compareTo(victim);
      if (match < 0)
        curr.left = delete(curr.left, victim);
      else if (match > 0)
        curr.right = delete(curr.right, victim);
      else {
        if (curr.left == null)
          retval = curr.right;
        else if (curr.right == null)
          retval = curr.left;
        else {
          Node successor = smallest(curr.right);
          curr.data = successor.data;
          curr.right = delete(curr.right, successor.data.getName());
        }
      }
    }
    return retval;
  }
  public void add(Animal newbie) {
    if (root == null)
      root = new Node(newbie);
    else
      add(root, newbie);
  }

  private void add(Node curr, Animal newbie) {
    if (curr.data.compareTo(newbie) < 0) { // go right
      if (curr.right == null)
        curr.right = new Node(newbie);
      else
        add(curr.right, newbie);
    } else { // go left
      if (curr.left == null)
        curr.left = new Node(newbie);
      else
        add(curr.left, newbie);
    }
  }

  private String indentedRepresentation(Node curr, String prefix) {
    String rep = "";
    if (curr != null) {
      rep += indentedRepresentation(curr.left, prefix+"  ");
      rep += prefix + curr.data + "\n";
      rep += indentedRepresentation(curr.right, prefix+"  ");
    }
    return rep;

  }

  private String indentedRepresentation(Node curr) {
    return indentedRepresentation(curr, "");
  }
  private String flushRepresentation(Node curr) {
    String rep = "";
    if (curr != null) {
      rep += flushRepresentation(curr.left);
      rep += curr.data + "\n";
      rep += flushRepresentation(curr.right);
    }
    return rep;
  }

  public String toString() {
    return flushRepresentation(root);
  }

  public int size() {
    return size(root);
  }

  private int size(Node curr) {
    int mySize = 0;
    if (curr != null)
      mySize = size(curr.left) + 1 + size(curr.right);
    return mySize;
  }

}
