package safariguide;

import animals.Dictionary;
import animals.Animal;

import java.util.Scanner;
import java.util.regex.Pattern;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class SafariGuide {
  String fname;
  Dictionary animals;

  private Animal readOneAnimal(Scanner fin) {
    String name = fin.nextLine();
    name = name.trim();
    String description = fin.nextLine();
    description = description.trim();
    return new Animal(name, description);
  }

  public SafariGuide(String fname) {
    this.fname = fname;
    animals = new Dictionary();
    try {
      FileInputStream stream = new FileInputStream(fname);
      Scanner fin = new Scanner(stream);

      while (fin.hasNext()) {
        Animal a = readOneAnimal(fin);
        if (!animals.contains(a.getName()))
          animals.add(a);
      }
    } catch (FileNotFoundException e) {
      System.out.println("Error " + e.getMessage());
      e.printStackTrace();
      System.exit(2);
    }
  }

  public void run() {
    System.out.printf("%d Words:\n%s\n", animals.size(), animals);
    System.out.println(animals);
  }

  public static void main(String[] args) {
    SafariGuide guide = new SafariGuide(args[0]);
    guide.run();
  }
}
