package arena;

import java.util.Random;

import critters.Critter;
import critters.Fighter;
import critters.Wizard;

public class Battle {
  private Random rng;
  public Battle() {
    rng = new Random();
  }

  public int threeD6() {
    return rng.nextInt(1, 7) + rng.nextInt(1, 7) + rng.nextInt(1, 7);
  }

  public Critter critterFactory(String name, Random rng) {
    Critter newCritter = null;
    int die = rng.nextInt(1, 100); // 99 values
    if (die < 34)
      newCritter = new Fighter(name, threeD6(), threeD6(), threeD6());
    else if (die < 67)
      newCritter = new Wizard(name, threeD6(), threeD6(), threeD6());
    else
      newCritter = new Wizard(name, threeD6(), threeD6(), threeD6());
    return newCritter;
  }

  public void run() {
    Critter critterA = critterFactory("Eric the Tan", rng);
    Critter critterB = critterFactory("Guldorn the Clumsy", rng);


    System.out.println("Let's Get Ready to Rumble!");

    System.out.println(critterA);
    System.out.println("versus");

    System.out.println(critterB);

    while (critterA.isAlive() && critterB.isAlive()) {
      int coin = rng.nextInt(1, 21);
      Critter first = critterA;
      Critter second = critterB;
      if (coin > 10) {
        first = critterB;
        second = critterA;
      }
      System.out.printf("%s attacks %s ", first.getName(), second.getName());
      if (first.attack(second, rng)) {
        int damage = first.doDamage(second, rng);
        System.out.printf("and HITS for %d points\n", damage);
      } else {
        System.out.printf("and misses\n");
      }

      if (second.isAlive()) {
        System.out.printf("%s attacks %s ", second.getName(), first.getName());
        if (second.attack(first, rng)) {
          int damage = second.doDamage(first, rng);
          System.out.printf("and HITS for %d points\n", damage);
        } else {
          System.out.printf("and misses\n");
        }
      }
    }
    if (critterA.isAlive()) {
      System.out.printf("%s drops %s, winning the battle.\n", critterA.getName(), critterB.getName());

    } else if (critterB.isAlive()) {
      System.out.printf("%s drops %s, winning the battle.\n", critterB.getName(), critterA.getName());
    } else {
      System.out.println("Both heroes died!");
    }
  }

  public static void main(String[] args) {
    Battle battle = new Battle();
    battle.run();
  }
}
