package util;

import java.lang.reflect.Array;
public class Queue<E> {
  class QNode {
    private QNode prev;
    private E data;
    private QNode next;

    QNode(QNode prev, E data, QNode next) {
      this.prev = prev;
      this.data = data;
      this.next = next;
    }
  }

  QNode head;
  QNode tail;

  public Queue() {
    head = null;
    tail = null;
  }
  //enqueue
  public void add(E newbie) {
    if (isEmpty()) {
      head = new QNode(null, newbie, null);
      tail = head;
    } else {
      tail.next = new QNode(tail, newbie, null);
      tail = tail.next;
    }
   }

  // dequeue
   public E poll() {
     E retval = null;
     if (!isEmpty()) {
       retval = head.data;
       if (head.next != null) {
         head.next.prev = null;
         head = head.next;
       } else {
         head = null;
         tail = null;
       }
     }
     return retval;
   }

   public E peek() {
     E retval = null;
     if (!isEmpty()) {
       retval = head.data;
     }
     return retval;
   }
  public boolean isEmpty() {
    return head == null;
   }

   public boolean isFull() {
     return false;
   }
 }
