package driver;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Scanner;

import menu.Menu;
import menu.BCLMenu;

public class Calculator {
  private final String CALCULATOR_MENU_FILE = "../data/calculator.menu";
  private Menu menu;

  public Calculator() {
    try {
      menu = new BCLMenu(new FileInputStream(CALCULATOR_MENU_FILE));
    }
    catch (FileNotFoundException e) {
      System.out.println("Error " + e.getMessage());
      e.printStackTrace();
    }
  }

  public void processAdd(Scanner keyboard) {
    System.out.print("First Number ");
    int first = keyboard.nextInt();
    System.out.print("Second Number ");
    int second = keyboard.nextInt();

    System.out.printf("%d + %d = %d\n", first, second, first + second);
  }

  public void processSubtract(Scanner keyboard) {
    System.out.print("First Number ");
    int first = keyboard.nextInt();
    System.out.print("Second Number ");
    int second = keyboard.nextInt();

    System.out.printf("%d - %d = %d\n", first, second, first - second);
  }

  public void processMultiply(Scanner keyboard) {
    System.out.print("First Number ");
    int first = keyboard.nextInt();
    System.out.print("Second Number ");
    int second = keyboard.nextInt();

    System.out.printf("%d * %d = %d\n", first, second, first * second);
  }

  public void processDivide(Scanner keyboard) {
    System.out.print("First Number ");
    int first = keyboard.nextInt();
    System.out.print("Second Number ");
    int second = keyboard.nextInt();

    System.out.printf("%d / %d = %d\n", first, second, first / second);
  }

  public void run() {
    boolean done = false;
    Scanner keyboard = new Scanner(System.in);
    while (!done) {
      String command = menu.match("Command? ", keyboard);

      switch (command) {
      case "quit":
        done = true;
        break;
      case "add":
        processAdd(keyboard);
        break;
      case "subtract":
        processSubtract(keyboard);
        break;
      case "multiply":
        processMultiply(keyboard);
        break;
      case "divide":
        processDivide(keyboard);
        break;
      }
      if (!done)
        keyboard.skip("\n");
    }

  }

  public static void main(String[] args) {
    Calculator rm = new Calculator();
    rm.run();
  }
}
