package critters;

import java.util.Random;

public class Attribute {
  public static final int SUCCESS_VALUE = 10;

  public enum Type {
    STR, DEX, INT, HP
  }
  private Type type;
  private int base;
  private int up;
  private int down;

  public Attribute(Type type, int base) {
    this.type = type;
    this.base = base;
    up = 0;
    down = 0;
  }

  public int current() {
    return base + up + down;
  }

  public int base() {
    return base;
  }

  public int nerf(int amount) {
    down -= amount;
    return current();
  }

  public int buff(int amount) {
    up += amount;
    return current();
  }

  public int heal(int amount) {
    down = Math.min(0, down + amount);
    return current();
  }

  public int deBuff(int amount) {
    down = Math.max(0, up -  amount);
    return current();
  }

  public int nerfTotal() {
    return -down;
  }

  public int buffTotal() {
    return up;
  }

  public int level(int amount) {
    base += amount;
    return current();
  }

  public int deBuffAll() {
    deBuff(buffTotal());
    return current();
  }

  public int healAll() {
    heal(nerfTotal());
    return current();
  }

  public boolean challenge(Attribute opposingAttribute, int delta, Random random) {
    int die = random.nextInt(1, 21);
    int  attempt = die + current();
    int opposition = opposingAttribute.current();
    return (attempt - opposition) >= SUCCESS_VALUE;
  }

  public boolean challenge(Attribute opposingAttribute, Random random) {
    return challenge(opposingAttribute, 0, random);
  }

  public String toString() {
    return String.format("%s: %d (+%d/-%d)",
                         type.toString(), current(),
                         buffTotal(), nerfTotal());
  }
}
