package critters;

import java.util.Random;

public class Critter {
  protected Attribute strength;
  protected Attribute dexterity;
  protected Attribute intelligence;

  protected Attribute hitPoints;

  private String name;

  public Critter(String name, int STR, int DEX, int INT, int HP) {
    this.name = name;
    strength = new Attribute(Attribute.Type.STR, STR);
    dexterity = new Attribute(Attribute.Type.DEX, DEX);
    intelligence = new Attribute(Attribute.Type.INT, INT);
    hitPoints = new Attribute(Attribute.Type.HP, HP);
  }

  public boolean attack(Critter opponent, Random random) {
    return strength.challenge(opponent.strength, random);
  }

  public int calculateDamage(Random random) {
    return random.nextInt(1, 7);
  }

  public int doDamage(Critter opponent, Random random) {
    int damage = calculateDamage(random);
    opponent.hitPoints.nerf(damage);
    return damage;
  }

  public boolean isAlive() {
    return hitPoints.current() > 0;
  }

  public String getName() {
    return name;
  }

  public String toString() {
    String template = """
      %s: %s
      Attributes--
      %s
      %s
      %s
      %s
      """;
      return String.format(template,
                           getClass().getSimpleName(), name,
                           strength, dexterity, intelligence, hitPoints);
  }
}
