/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package main;

import messages.Message;
import messages.TextMessage;
import messages.VerticalMessage;
import messages.BoxedMessage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DecorateMessages {
  private List<String> arguments;

  private List<Message> messages;

  public DecorateMessages(String[] args) {
    arguments = new ArrayList<String>(Arrays.asList(args));
    messages = new ArrayList<Message>();
  }

  private void run() {
    for (String arg : arguments) {
      processArgument(arg);
    }

    for (Message m : messages) {
      System.out.println(m);
    }
  }

  private void processArgument(String fname) {
    Message x = new TextMessage(fname);
    messages.add(x);
    Message bx = new BoxedMessage(x);
    messages.add(bx);
    bx = new BoxedMessage(x, "012345678");
    Message bbx = new BoxedMessage(bx);
    messages.add(bbx);
    bx = new BoxedMessage(x, "**********");
    messages.add(new BoxedMessage(new VerticalMessage(x, bx)));

    bx = new BoxedMessage(x, "**********");
    bbx = new BoxedMessage(new VerticalMessage(x, bx));
    messages.add(bbx);
  }

  public static void main(String[] args) {
    if (args.length < 1) {
      System.err.println("usage: Decorate Messages [<data file name>]+");
      System.err.println();
      System.err.println("       where");
      System.err.println("         <data file name> - names a file containing text description of Messages");
      System.exit(1);
    }

    DecorateMessages dm = new DecorateMessages(args);
    dm.run();
  }
}
