package messages;
public class BoxedMessage
  extends Message {
  private final String outline;
  private final Message inner;
  // edge characters:
  //  tlc   t   trc
  //   l         r
  //  blc   b   brc

  private final String tlc;
  private final String t;
  private final String trc;
  private final String l;
  private final String r;
  private final String blc;
  private final String b;
  private final String brc;

  public BoxedMessage(Message m, String outline) {
    super(m.width() + 2, m.height() + 2);
    inner = m;
    tlc = outline.substring(0, 1);
    t = outline.substring(1, 2);
    trc = outline.substring(2, 3);
    l = outline.substring(3, 4);
    r = outline.substring(5, 6);
    blc = outline.substring(6, 7);
    b = outline.substring(7, 8);
    brc = outline.substring(8, 9);

    this.outline = outline;
  }

  public BoxedMessage(Message m) {
    this (m, "+-+| |+-+");
  }

  private String top() {
    String middle = t;
    while (middle.length() < inner.width())
      middle += middle;
    return tlc + middle.substring(0, width()-2) + trc;
  }

  private String bottom() {
    String middle = b;
    while (middle.length() < inner.width())
      middle += middle;
    return blc + middle.substring(0, width()-2) + brc;
  }

  public String line(int i) {
    validateLineIndex(i);
    String theLine = HUNDRED_SPACES.substring(0, width());
    if ((0 <= i) && (i < minimum_height)) {
      if (i == 0)
        theLine = top() + theLine;
      else if (i == minimum_height - 1)
        theLine = bottom() + theLine;
      else
        theLine = l + inner.line(i - 1) + r + theLine;
    }
    return theLine.substring(0, width());
  }
}
