package messages;
import java.lang.IndexOutOfBoundsException;
public class Message {
  public static final String HUNDRED_SPACES =
    "                                                  " +
    "                                                  ";
  protected int minimum_height;
  protected int minimum_width;
  private int current_width;
  private int current_height;

  public Message(int width, int height) {
    minimum_height = height;
    minimum_width = width;
    current_height = minimum_height;
    current_width = minimum_width;
  }

  public int width() {
    return current_width;
  }

  public int height() {
    return current_height;
  }

  protected void validateLineIndex(int i) {
    if (!((0 <= i) && (i < height())))
      throw new IndexOutOfBoundsException(i);
  }

  public String line(int i) {
    validateLineIndex(i);
    return "";
  }

  public String toString() {
    String separator = "";
    String retval = "";
    for (int i = 0; i < height(); i++) {
      retval += separator + line(i);
      separator = "\n";
    }
    return retval;
  }

  protected int height(int proposed_height) {
    if (proposed_height >= minimum_height)
      current_height = proposed_height;
    return current_height;
  }

  protected int width(int proposed_width) {
    if (proposed_width >= minimum_width)
      current_width = proposed_width;
    return current_width;
  }
}
