package messages;
public class VerticalMessage
  extends Message {
  private final Message top;
  private final Message bottom;

  public VerticalMessage(Message top, Message bottom) {
    super(Math.max(top.width(), bottom.width()),
          top.height()+bottom.height());
    this.top = top;
    top.width(minimum_width);
    this.bottom = bottom;
    bottom.width(minimum_width);
  }

  public String line(int i) {
    validateLineIndex(i);
    String theLine = HUNDRED_SPACES.substring(0, width());
    if ((0 <= i) && (i < top.height())) {
      theLine = top.line(i) + theLine;
    } else if ((i - top.height()) < bottom.height()) {
      theLine = bottom.line(i - top.height()) + theLine;
    }
    return theLine.substring(0, width());
  }
}
